/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowHistory;
import filenet.vw.api.VWWorkflowMilestones;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Vector;

public final class VWProcess
extends VWMLABase
implements Serializable {
    private static final long DELAY_QUEUE_ID = -6L;
    private static final long serialVersionUID = 7536L;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_COMPLETED_STEP_HISTORY = 1;
    protected String processId;
    protected int bufferSize = 100;
    protected VWRoster theRoster = null;
    protected String rosterName = null;
    protected VWSession serviceSession = null;
    protected VWRosterQuery rosterQuery = null;
    protected String workObjectNumber;
    protected String eventLogName = null;
    protected String workClassName = null;
    protected VWMilestoneDefinition[] mileStoneDefinitions = null;
    protected int workSpaceId = 0;
    protected int workClassId = 0;
    private boolean bInitialized = false;
    private boolean bInitializing = false;
    private VWWorkflowDefinition theWorkflowDef = null;
    private boolean theLastConvertFlag = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-03-11 22:51:21 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Jane Luo;5D5709897;janeluo@us.ibm.com (jluo) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/2 $";
    }

    protected VWProcess(String theRosterName, String theEventLogName, String theWorkClassName, String theProcessId, VWMilestoneDefinition[] theMileStoneDefinitions, int theWorkSpaceId, int theWorkClassId) throws VWException {
        this.processId = theProcessId;
        this.rosterName = theRosterName;
        this.eventLogName = theEventLogName;
        this.workClassName = theWorkClassName;
        this.mileStoneDefinitions = theMileStoneDefinitions;
        this.workSpaceId = theWorkSpaceId;
        this.workClassId = theWorkClassId;
        this.bInitialized = false;
    }

    public VWWorkflowMilestones fetchReachedWorkflowMilestones(int theLevel) throws VWException {
        return new VWWorkflowMilestones(this.serviceSession, this.processId, this.mileStoneDefinitions, this.eventLogName, theLevel);
    }

    public VWMilestoneElement[] fetchFilteredWorkflowMilestones(int level, boolean bLastOnly, boolean bReachedOnly) throws VWException {
        int i;
        int sz;
        Object[] milestoneElements = null;
        Vector<VWMilestoneElement> milestonesList = new Vector<VWMilestoneElement>();
        if (!bReachedOnly) {
            VWMilestoneDefinition[] milestoneDefs = this.getMilestoneDefinitions();
            sz = milestoneDefs.length;
            for (i = 0; i < sz; ++i) {
                if (milestoneDefs[i].getLevel() > level) continue;
                VWMilestoneElement theMilestone = new VWMilestoneElement(milestoneDefs[i], i);
                milestonesList.addElement(theMilestone);
            }
        }
        VWWorkflowMilestones reachedMilestone = this.fetchReachedWorkflowMilestones(level);
        while (reachedMilestone.hasNext()) {
            VWMilestoneElement theMilestone = reachedMilestone.next();
            if (theMilestone.getLevel() > level) continue;
            int id = theMilestone.getMilestoneId();
            sz = milestonesList.size();
            int idx = 0;
            VWMilestoneElement eleFound = null;
            for (int i2 = 0; i2 < sz; ++i2) {
                VWMilestoneElement mEle = (VWMilestoneElement)milestonesList.elementAt(i2);
                if (mEle.getMilestoneId() != id) continue;
                eleFound = mEle;
                idx = i2;
                if (bLastOnly) break;
            }
            if (eleFound == null) {
                milestonesList.addElement(theMilestone);
                continue;
            }
            if (bLastOnly) {
                Date mEleTimestamp = eleFound.getTimestamp();
                if (mEleTimestamp != null && !mEleTimestamp.before(theMilestone.getTimestamp()) && !mEleTimestamp.equals(theMilestone.getTimestamp())) continue;
                milestonesList.removeElementAt(idx);
                milestonesList.insertElementAt(theMilestone, idx);
                continue;
            }
            if (eleFound.getTimestamp() == null) {
                milestonesList.removeElementAt(idx);
                milestonesList.insertElementAt(theMilestone, idx);
                continue;
            }
            milestonesList.insertElementAt(theMilestone, idx + 1);
        }
        sz = milestonesList.size();
        if (sz <= 0) {
            return null;
        }
        milestoneElements = new VWMilestoneElement[milestonesList.size()];
        milestonesList.copyInto(milestoneElements);
        if (milestoneElements != null) {
            for (i = 0; i < milestoneElements.length; ++i) {
                ((VWMLABase)milestoneElements[i]).setSession(this.serviceSession);
            }
        }
        return milestoneElements;
    }

    public VWWorkflowHistory fetchWorkflowHistory(int instructionSheetID) throws VWException {
        return new VWWorkflowHistory(this.serviceSession, instructionSheetID, this.processId, this.eventLogName, this);
    }

    public VWWorkObject next() throws VWException {
        this.initialize();
        if (this.rosterQuery != null) {
            return (VWWorkObject)this.rosterQuery.next();
        }
        return null;
    }

    public int getBufferSize() {
        if (this.theRoster != null) {
            return this.theRoster.getBufferSize();
        }
        return this.bufferSize;
    }

    public void setBufferSize(int newSize) throws VWException {
        this.initialize();
        if (this.theRoster != null) {
            this.theRoster.setBufferSize(newSize);
        }
        this.bufferSize = newSize;
    }

    protected String getProcessId() {
        return this.processId;
    }

    protected void setProcessId(String theProcessId) {
        this.processId = theProcessId;
    }

    protected boolean endOfQuery() {
        if (this.rosterQuery != null) {
            return this.rosterQuery.endOfQuery();
        }
        return false;
    }

    public boolean hasNext() throws VWException {
        this.initialize();
        if (this.rosterQuery != null) {
            return this.rosterQuery.hasNext();
        }
        return true;
    }

    public void resetFetch() {
        if (this.rosterQuery != null) {
            this.rosterQuery.resetFetch();
        }
    }

    public void delete() throws VWException {
        boolean bGotOne = false;
        int nIterationCount = 0;
        do {
            bGotOne = false;
            ++nIterationCount;
            this.resetFetch();
            while (this.hasNext()) {
                VWWorkObject theWobj = this.next();
                if (theWobj == null) continue;
                bGotOne = true;
                theWobj.doLock(true);
                theWobj.doTerminate();
            }
        } while (nIterationCount < 10 && bGotOne);
        if (bGotOne && nIterationCount >= 10) {
            throw new VWException("vw.api.VWProcessDeleteIncomplete", "Unable to delete all of the work items for Process \"{0}\".", this.workObjectNumber);
        }
    }

    public String getRosterName() throws VWException {
        return this.translateStr(this.rosterName);
    }

    public String getEventLogName() throws VWException {
        return this.translateStr(this.eventLogName);
    }

    public String getWorkClassName() throws VWException {
        return this.translateStr(this.workClassName);
    }

    public VWMilestoneDefinition[] getMilestoneDefinitions() throws VWException {
        return this.mileStoneDefinitions;
    }

    public VWWorkflowDefinition fetchWorkflowDefinition() throws VWException {
        return this.fetchWorkflowDefinition(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWWorkflowDefinition fetchWorkflowDefinition(boolean convert) throws VWException {
        if (this.theWorkflowDef != null && this.theLastConvertFlag == convert) {
            return this.theWorkflowDef;
        }
        BufferedReader bRdr = null;
        try {
            String xmlString = this.serviceSession.getCmdSession().getWorkClassXML(this.workSpaceId, this.workClassName, true, convert);
            bRdr = new BufferedReader(new StringReader(xmlString));
            this.theWorkflowDef = VWWorkflowDefinition.read(bRdr);
            this.theWorkflowDef.setSession(this.serviceSession);
            this.theLastConvertFlag = convert;
            VWWorkflowDefinition vWWorkflowDefinition = this.theWorkflowDef;
            return vWWorkflowDefinition;
        }
        finally {
            if (bRdr != null) {
                try {
                    bRdr.close();
                }
                catch (Exception E) {}
            }
        }
    }

    protected void setServiceSession(VWSession theServiceSession) {
        this.serviceSession = theServiceSession;
    }

    void initialize() throws VWException {
        if (this.bInitializing || this.bInitialized) {
            return;
        }
        try {
            this.bInitializing = true;
            if (this.serviceSession == null) {
                throw new VWException("vw.api.ProcessSessionIsNull", "No logged-on session exists for this process.");
            }
            this.serviceSession.checkSession();
            this.theRoster = this.serviceSession.getRoster(this.rosterName);
            this.theRoster.setBufferSize(this.bufferSize);
            boolean isIndex = false;
            boolean isExpField = false;
            String theIndexName = null;
            VWRosterDefinition rosterDef = this.theRoster.fetchRosterDefinition();
            if (rosterDef != null) {
                VWExposedFieldDefinition[] expFields = rosterDef.getFields();
                int fCount = 0;
                if (expFields != null) {
                    fCount = expFields.length;
                }
                for (int i = 0; i < fCount && !isExpField; ++i) {
                    String theFieldName = expFields[i].getAuthoredName();
                    if (theFieldName.compareTo("F_WorkFlowNumber") != 0) continue;
                    isExpField = true;
                }
                if (!isExpField) {
                    throw new VWException("vw.api.ProcessNeedWFLNum", "F_WorkFlowNumber must be an exposed field to use this.");
                }
                VWIndexDefinition[] indexDefs = rosterDef.getIndexes();
                int count = 0;
                if (indexDefs != null) {
                    count = indexDefs.length;
                }
                for (int i = 0; i < count && !isIndex; ++i) {
                    String[] theFieldNames = indexDefs[i].getAuthoredFieldNames();
                    if (theFieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    theIndexName = indexDefs[i].getAuthoredName();
                    isIndex = true;
                }
            }
            if (isIndex) {
                Object[] minValues = new Object[]{this.processId};
                Object[] maxValues = new Object[]{this.processId};
                this.rosterQuery = this.theRoster.createQuery(theIndexName, minValues, maxValues, 96, null, null, 1);
            } else {
                Object[] theValues = new Object[]{new VWWorkObjectNumber(this.processId)};
                this.rosterQuery = this.theRoster.createQuery("", null, null, 0, "F_WorkFlowNumber = :x", theValues, 1);
            }
        }
        catch (VWException ex) {
            this.bInitializing = false;
            throw ex;
        }
        this.bInitializing = false;
        this.bInitialized = true;
    }

    public VWWorkflowHistory fetchFilteredWorkflowHistory(int mapId, int filterFlag) throws VWException {
        VWWorkflowHistory oWflHistory = new VWWorkflowHistory(this.serviceSession, mapId, this.processId, this.eventLogName, this);
        oWflHistory.setHistoryFilter(filterFlag);
        return oWflHistory;
    }

    public VWSession getSession() throws VWException {
        return this.serviceSession;
    }
}

